-- ============================================================
  --  MyBBForge — Forum Structure Setup
  --  Run this ONCE in phpMyAdmin on your MyBB database.
  --  Change the table prefix below if yours isn't mybb_
  -- ============================================================

  SET NAMES utf8mb4;
  SET @prefix = 'mybb_';

  -- Helper: disable FK checks during insert
  SET FOREIGN_KEY_CHECKS = 0;

  -- ────────────────────────────────────────────────────────────
  --  CATEGORY 1: Theme Releases
  -- ────────────────────────────────────────────────────────────
  INSERT INTO mybb_forums
    (name, description, linkto, type, pid, parentlist, disporder, active, `open`,
     threads, posts, lastpost, lastposter, lastposttid, lastpostsubject,
     usepostcounts, usethreadcounts, requireprefix, password, showinjump,
     style, overridestyle, rulestype, rulestext,
     unapprovedthreads, unapprovedposts, deletedthreads, deletedposts,
     defaultdatecut, defaultsortby, defaultsortorder, color)
  VALUES
    ('Theme Releases', 'Download free and premium MyBB 1.9 themes', '', 'c', 0, '',
     1, 1, 1, 0, 0, 0, '', 0, '', 1, 1, 0, '', 1, 0, 0, 0, '', 0, 0, 0, 0, 0, '', '', '');

  SET @cat1 = LAST_INSERT_ID();
  UPDATE mybb_forums SET parentlist = @cat1 WHERE fid = @cat1;

  -- Sub-forums of Theme Releases
  INSERT INTO mybb_forums (name, description, linkto, type, pid, parentlist, disporder, active, `open`, threads, posts, lastpost, lastposter, lastposttid, lastpostsubject, usepostcounts, usethreadcounts, requireprefix, password, showinjump, style, overridestyle, rulestype, rulestext, unapprovedthreads, unapprovedposts, deletedthreads, deletedposts, defaultdatecut, defaultsortby, defaultsortorder, color)
  VALUES ('NightVision Xbox', 'Xbox-inspired dark theme with glassmorphic card grid. Free forever.', '', 'f', @cat1, '', 1, 1, 1, 0, 0, 0, '', 0, '', 1, 1, 0, '', 1, 0, 0, 0, '', 0, 0, 0, 0, 0, '', '', '');
  SET @f1 = LAST_INSERT_ID();
  UPDATE mybb_forums SET parentlist = CONCAT(@cat1, ',', @f1) WHERE fid = @f1;

  INSERT INTO mybb_forums (name, description, linkto, type, pid, parentlist, disporder, active, `open`, threads, posts, lastpost, lastposter, lastposttid, lastpostsubject, usepostcounts, usethreadcounts, requireprefix, password, showinjump, style, overridestyle, rulestype, rulestext, unapprovedthreads, unapprovedposts, deletedthreads, deletedposts, defaultdatecut, defaultsortby, defaultsortorder, color)
  VALUES ('Premium Themes', 'Exclusive premium themes with lifetime updates and priority support.', '', 'f', @cat1, '', 2, 1, 1, 0, 0, 0, '', 0, '', 1, 1, 0, '', 1, 0, 0, 0, '', 0, 0, 0, 0, 0, '', '', '');
  SET @f2 = LAST_INSERT_ID();
  UPDATE mybb_forums SET parentlist = CONCAT(@cat1, ',', @f2) WHERE fid = @f2;

  INSERT INTO mybb_forums (name, description, linkto, type, pid, parentlist, disporder, active, `open`, threads, posts, lastpost, lastposter, lastposttid, lastpostsubject, usepostcounts, usethreadcounts, requireprefix, password, showinjump, style, overridestyle, rulestype, rulestext, unapprovedthreads, unapprovedposts, deletedthreads, deletedposts, defaultdatecut, defaultsortby, defaultsortorder, color)
  VALUES ('Free Themes', 'Community-submitted free themes. All fully supported on MyBB 1.9.', '', 'f', @cat1, '', 3, 1, 1, 0, 0, 0, '', 0, '', 1, 1, 0, '', 1, 0, 0, 0, '', 0, 0, 0, 0, 0, '', '', '');
  SET @f3 = LAST_INSERT_ID();
  UPDATE mybb_forums SET parentlist = CONCAT(@cat1, ',', @f3) WHERE fid = @f3;

  INSERT INTO mybb_forums (name, description, linkto, type, pid, parentlist, disporder, active, `open`, threads, posts, lastpost, lastposter, lastposttid, lastpostsubject, usepostcounts, usethreadcounts, requireprefix, password, showinjump, style, overridestyle, rulestype, rulestext, unapprovedthreads, unapprovedposts, deletedthreads, deletedposts, defaultdatecut, defaultsortby, defaultsortorder, color)
  VALUES ('Theme GitHub', 'Open-source themes on GitHub — fork, modify, contribute.', '', 'f', @cat1, '', 4, 1, 1, 0, 0, 0, '', 0, '', 1, 1, 0, '', 1, 0, 0, 0, '', 0, 0, 0, 0, 0, '', '', '');
  SET @f4 = LAST_INSERT_ID();
  UPDATE mybb_forums SET parentlist = CONCAT(@cat1, ',', @f4) WHERE fid = @f4;

  -- ────────────────────────────────────────────────────────────
  --  CATEGORY 2: Development
  -- ────────────────────────────────────────────────────────────
  INSERT INTO mybb_forums (name, description, linkto, type, pid, parentlist, disporder, active, `open`, threads, posts, lastpost, lastposter, lastposttid, lastpostsubject, usepostcounts, usethreadcounts, requireprefix, password, showinjump, style, overridestyle, rulestype, rulestext, unapprovedthreads, unapprovedposts, deletedthreads, deletedposts, defaultdatecut, defaultsortby, defaultsortorder, color)
  VALUES ('Development', 'Twig templates and MyBB 1.9 plugin dev', '', 'c', 0, '', 2, 1, 1, 0, 0, 0, '', 0, '', 1, 1, 0, '', 1, 0, 0, 0, '', 0, 0, 0, 0, 0, '', '', '');
  SET @cat2 = LAST_INSERT_ID();
  UPDATE mybb_forums SET parentlist = @cat2 WHERE fid = @cat2;

  INSERT INTO mybb_forums (name, description, linkto, type, pid, parentlist, disporder, active, `open`, threads, posts, lastpost, lastposter, lastposttid, lastpostsubject, usepostcounts, usethreadcounts, requireprefix, password, showinjump, style, overridestyle, rulestype, rulestext, unapprovedthreads, unapprovedposts, deletedthreads, deletedposts, defaultdatecut, defaultsortby, defaultsortorder, color)
  VALUES ('Theme Development', 'Twig template architecture, SCSS tricks, and MyBB 1.9 theming deep-dives.', '', 'f', @cat2, '', 1, 1, 1, 0, 0, 0, '', 0, '', 1, 1, 0, '', 1, 0, 0, 0, '', 0, 0, 0, 0, 0, '', '', '');
  SET @f5 = LAST_INSERT_ID();
  UPDATE mybb_forums SET parentlist = CONCAT(@cat2, ',', @f5) WHERE fid = @f5;

  INSERT INTO mybb_forums (name, description, linkto, type, pid, parentlist, disporder, active, `open`, threads, posts, lastpost, lastposter, lastposttid, lastpostsubject, usepostcounts, usethreadcounts, requireprefix, password, showinjump, style, overridestyle, rulestype, rulestext, unapprovedthreads, unapprovedposts, deletedthreads, deletedposts, defaultdatecut, defaultsortby, defaultsortorder, color)
  VALUES ('Plugin Development', 'Build, share and get support for MyBB 1.9 plugins.', '', 'f', @cat2, '', 2, 1, 1, 0, 0, 0, '', 0, '', 1, 1, 0, '', 1, 0, 0, 0, '', 0, 0, 0, 0, 0, '', '', '');
  SET @f6 = LAST_INSERT_ID();
  UPDATE mybb_forums SET parentlist = CONCAT(@cat2, ',', @f6) WHERE fid = @f6;

  INSERT INTO mybb_forums (name, description, linkto, type, pid, parentlist, disporder, active, `open`, threads, posts, lastpost, lastposter, lastposttid, lastpostsubject, usepostcounts, usethreadcounts, requireprefix, password, showinjump, style, overridestyle, rulestype, rulestext, unapprovedthreads, unapprovedposts, deletedthreads, deletedposts, defaultdatecut, defaultsortby, defaultsortorder, color)
  VALUES ('Support', 'Get help installing themes, debugging issues, and configuring MyBB 1.9.', '', 'f', @cat2, '', 3, 1, 1, 0, 0, 0, '', 0, '', 1, 1, 0, '', 1, 0, 0, 0, '', 0, 0, 0, 0, 0, '', '', '');
  SET @f7 = LAST_INSERT_ID();
  UPDATE mybb_forums SET parentlist = CONCAT(@cat2, ',', @f7) WHERE fid = @f7;

  -- ────────────────────────────────────────────────────────────
  --  CATEGORY 3: Community
  -- ────────────────────────────────────────────────────────────
  INSERT INTO mybb_forums (name, description, linkto, type, pid, parentlist, disporder, active, `open`, threads, posts, lastpost, lastposter, lastposttid, lastpostsubject, usepostcounts, usethreadcounts, requireprefix, password, showinjump, style, overridestyle, rulestype, rulestext, unapprovedthreads, unapprovedposts, deletedthreads, deletedposts, defaultdatecut, defaultsortby, defaultsortorder, color)
  VALUES ('Community', 'General talk, announcements and hangouts', '', 'c', 0, '', 3, 1, 1, 0, 0, 0, '', 0, '', 1, 1, 0, '', 1, 0, 0, 0, '', 0, 0, 0, 0, 0, '', '', '');
  SET @cat3 = LAST_INSERT_ID();
  UPDATE mybb_forums SET parentlist = @cat3 WHERE fid = @cat3;

  INSERT INTO mybb_forums (name, description, linkto, type, pid, parentlist, disporder, active, `open`, threads, posts, lastpost, lastposter, lastposttid, lastpostsubject, usepostcounts, usethreadcounts, requireprefix, password, showinjump, style, overridestyle, rulestype, rulestext, unapprovedthreads, unapprovedposts, deletedthreads, deletedposts, defaultdatecut, defaultsortby, defaultsortorder, color)
  VALUES ('General Discussion', 'Anything goes — off-topic chat, forum news, and community hangout.', '', 'f', @cat3, '', 1, 1, 1, 0, 0, 0, '', 0, '', 1, 1, 0, '', 1, 0, 0, 0, '', 0, 0, 0, 0, 0, '', '', '');
  SET @f8 = LAST_INSERT_ID();
  UPDATE mybb_forums SET parentlist = CONCAT(@cat3, ',', @f8) WHERE fid = @f8;

  INSERT INTO mybb_forums (name, description, linkto, type, pid, parentlist, disporder, active, `open`, threads, posts, lastpost, lastposter, lastposttid, lastpostsubject, usepostcounts, usethreadcounts, requireprefix, password, showinjump, style, overridestyle, rulestype, rulestext, unapprovedthreads, unapprovedposts, deletedthreads, deletedposts, defaultdatecut, defaultsortby, defaultsortorder, color)
  VALUES ('Rules & Archive', 'Forum rules and archived announcements. Read-only.', '', 'f', @cat3, '', 2, 1, 0, 0, 0, 0, '', 0, '', 1, 1, 0, '', 1, 0, 0, 0, '', 0, 0, 0, 0, 0, '', '', '');
  SET @f9 = LAST_INSERT_ID();
  UPDATE mybb_forums SET parentlist = CONCAT(@cat3, ',', @f9) WHERE fid = @f9;

  -- ────────────────────────────────────────────────────────────
  --  Board name update
  -- ────────────────────────────────────────────────────────────
  UPDATE mybb_settings SET value = 'MyBBForge' WHERE name = 'bbname';
  UPDATE mybb_settings SET value = 'The home of premium MyBB 1.9 themes.' WHERE name = 'bbdescription';

  -- ────────────────────────────────────────────────────────────
  --  Re-cache forum list so MyBB sees the new forums immediately
  -- ────────────────────────────────────────────────────────────
  DELETE FROM mybb_datacache WHERE title = 'forums';

  SET FOREIGN_KEY_CHECKS = 1;

  -- Done! Visit your forum — it should now show all 3 categories.
  -- If you need to undo this, delete forums with names matching the ones above.
  SELECT 'MyBBForge forum structure installed successfully!' AS result;
  